//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import {  useEffect, useRef, useState } from '@wordpress/element'
//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { useBlockProps, useInnerBlocksProps, store as blockEditorStore, } from '@wordpress/block-editor';
//@ts-ignore: Cannot find module '@wordpress/data' or its corresponding type declarations.
import { useSelect } from '@wordpress/data';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Placeholder, TextControl, Button, Notice } from '@wordpress/components'
import { AttributesCanvas1d } from '../types';

//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { InspectorControls } from '@wordpress/block-editor';

//import InspectorControls as MyInspectorControls from './inspector-controls';
//import BlockControls from './block-controls';
import { IconCanvas1d } from '../../../../icons'
import getScrollsequenceFop from '../../../getScrollsequenceFop';
import { DC3D } from '../../../../dbg'

declare const wp: any; 
const { applyFilters, } = wp.hooks;

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
interface EditProps {
    clientId: string,
    attributes: AttributesCanvas1d,
    setAttributes: any,
    name: string,
    onRemove: any, //  () => removeBlock(clientId)
    onReplace: any, //  (...args) => {…}
    // ... more attributes
    
}
export default function Edit(props:EditProps) {

    const { 
        clientId,
        attributes, 
        setAttributes,
        attributes:{
            height, 
            heightUnit, 
            lottieUrl,
            //... more attributes
        }, 
        onRemove,
        onReplace,
    } = props;

    const defaultAttributes = useSelect((select:any) => { // Access the default values
        return select('core/blocks').getBlockType('scroll-sequence/v2-canvas2d').attributes
    }, []); //console.log('defaultAttributes',defaultAttributes)

    const heightWithUnit =
    height && heightUnit
        ? `${ height }${ heightUnit }`
        : height;


    const elRef = useRef<any>(null)
    const blockProps = useBlockProps({
        style: {
            height: heightWithUnit ? heightWithUnit : undefined,
            width:  '100%',
        },
        //className: `ssq-relative`
        ref: elRef

    });

    // const [localValueSplineCodeUrl, setLocalValueSplineCodeUrl] = useState(attributes.splinecodeurl)
    // function confirmSplineCodeUrl(){
    //     // Check if URL is valid, correct etc ...
    //     if ( localValueSplineCodeUrl.replace(/\/+$/, '').endsWith(".splinecode")){
    //       setAttributes( { splinecodeurl: localValueSplineCodeUrl } )
    //     } else {
    //       alert('Wrong URL format. URL needs to end with .splinecode')
    //     }
    // }    

   
    useEffect(() => {
        //DC2D&&
        console.log('canvas2d useEffect[attributes] elRef.current.id',elRef.current?.id)
        getScrollsequenceFop(elRef.current)?.createBlock(elRef.current);
        getScrollsequenceFop(elRef.current)?.preloadAll(); // added
        return () => {
            console.log('canvas2d useEffect[attributes] CLEANUP elRef.current.id',elRef.current?.id)
            getScrollsequenceFop(elRef.current)?.destroyBlock(elRef.current)
        };
    }, [attributes]);	

    return (
        <>
            {/* <BlockControls
                attributes={attributes} 
                setAttributes={setAttributes} 
            />        
          
            <MyInspectorControls 
                attributes={attributes} 
                setAttributes={setAttributes} 
                defaultAttributes={defaultAttributes} 
                localValueSplineCodeUrl={localValueSplineCodeUrl}
                setLocalValueSplineCodeUrl={setLocalValueSplineCodeUrl}
            />         */}
            {/* <InspectorControls>
                {applyFilters('scrollsequence-freeversion-notice',
                    <Notice status="error">
                        <p>
                            Block is not implemented in Free plan. Only premium plans have this feature ready for testing at the moment.
                        </p>
                    </Notice>
                )}                
            </InspectorControls> */}

            { lottieUrl 
            ?
                <div {...blockProps} data-ssq-canvas3d={JSON.stringify(attributes)}  >
                    <canvas></canvas>
                </div>
            :		
                <div {...blockProps}>
                    <Placeholder
                        icon={ IconCanvas1d }
                        instructions={__('Enter Spline code URL','scrollsequence')}
                        label={__('Canvas 3D ','scrollsequence')}
                    >
                        TODO: a lottie url input field here (wp component)


                        {/* <TextControl
                            label="Spline code URL"
                            value={ localValueSplineCodeUrl }
                            onChange={ (value : string ) => {
                                setLocalValueSplineCodeUrl(  value  )
                            }}
                        /> */}

                        {/* <div style={{position:"relative"}}>
                            <MyMediaUploader attributes={attributes} setAttributes={setAttributes} imageGroupIndex={0}/>
                            <Button 
                                variant='secondary'	
                                style={{margin:"0.3rem"}}
                                onClick={ ()=>{
                                    addImageGroupUrlList({attributes, setAttributes })
                                }}
                            >
                                URL list
                            </Button>
                            <Button 
                                variant="secondary"	
                                style={{margin:"0.3rem"}}
                                onClick={ ()=>{
                                    addImageGroupGap({attributes, setAttributes }) 
                                }}
                            >
                                Gap
                            </Button>
                        </div> */}
                    </Placeholder>	
                </div>
            }        

        
        </>
    )
}