/**
 * Registers a new block provided a unique name and an object defining its behavior.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/blocks' or its corresponding type declarations.
import { registerBlockType } from '@wordpress/blocks';
//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { InnerBlocks   } from '@wordpress/block-editor';

/**
 * Internal dependencies
 */
import Edit from './edit';
//@ts-ignore: Cannot find module './block.json'. Consider using '--resolveJsonModule' to import module with '.json' extension.
import metadata from './block.json';
import { IconCanvas1d } from '../../../icons'


/**
 * Every block starts by registering a new block type definition.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-registration/
 */
registerBlockType( metadata.name, {
    /**
     * @see ./edit.js
     */
    icon: IconCanvas1d,
    // example: { // AK: Todo, below is from cover block
    // 	attributes: {
    //	// todo: add attributes
    // 	},
    // 	innerBlocks: [
    // 		{
    // 			name: 'core/paragraph',
    // 			attributes: {
    // 				content: __( '<strong>Another day on Earth</strong>' ),
    // 				align: 'center',
    // 			},
    // 		},
    // 	],
    // },	

    
    edit: Edit,
    save: (props:any) =>{
        return (
          <InnerBlocks.Content/>
        )
    },
} );