import React from 'react';

//@ts-ignore:
import { ToolbarButton, Spinner, Icon } from '@wordpress/components';
//@ts-ignore:
import { BlockControls } from '@wordpress/block-editor';
import { IconSparkle } from '../../../../../icons'


import { useToolsContext } from '../media3tools/ContextProvider'; 

// this component is used to toggle a boolean and show the status of the boolean as active/inactive button state
// it receives showMediaGroupAdder and setShowMediaGroupAdder as props from the parent component BlockControlsCanvas2d

export default function ButtonMediaTools({ show, setShow }: {show: 'canvas' | 'adder' | 'media-tools', setShow: React.Dispatch<React.SetStateAction<'canvas' | 'adder' | 'media-tools'>>}) {

    const { progress : { busy} } = useToolsContext();
    
    return (
        <ToolbarButton
            icon={ ( busy === 'generating' || busy === 'uploading' ) ? <Icon icon={<Spinner  style={{ height: '12px',  width: '12px', marginTop:0  }}  />} /> : <IconSparkle width={16} height={16} /> }
            label="Media Tools"
            onClick={() => {
                setShow(show === 'media-tools' ? 'canvas' : 'media-tools')
            }}
            isActive={show === 'media-tools'}
        />
    );
}