//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { BlockControls} from '@wordpress/block-editor';
import { AttributesCanvas2d } from '../../types';
import FullSizeButton from '../../../../components/block-controls-canvasxd/FullSizeButton';
import ButtonSceneWrapper from '../../../../components/canvasxd/ButtonSceneWrapper';
import ButtonMediaGroupAdder from './ButtonMediaGroupAdder';
import ButtonMediaTools from './ButtonMediaTools';
import React from 'react';
export default function BlockControlsCanvas2d({
    clientId,
    attributes, 
    setAttributes,
    hasMediaGroups,
    show,
    setShow,
    defaultAttributes,
}:{
    clientId: string,
    attributes: AttributesCanvas2d 
    setAttributes: any,
    hasMediaGroups: boolean,
    show: 'canvas' | 'adder' | 'media-tools',
    setShow: React.Dispatch<React.SetStateAction<'canvas' | 'adder' | 'media-tools'>>,
    defaultAttributes:any
}){
    return (
        <>
            <BlockControls group="block">
                <FullSizeButton
                    attributes={ attributes }
                    setAttributes={ setAttributes }
                    defaultAttributes={ defaultAttributes }
                />
                <ButtonMediaGroupAdder
                    show={show}
                    setShow={setShow}
                />
                <ButtonMediaTools
                    show={show}
                    setShow={setShow}
                />                        
                <ButtonSceneWrapper clientId={clientId} />
            </BlockControls>
        </>
    )
}