//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/data' or its corresponding type declarations.
import { useSelect } from '@wordpress/data';
//@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
import { InspectorControls } from '@wordpress/block-editor';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { Panel, PanelBody, Notice } from '@wordpress/components'

import ScrollTriggerControlBlocks from '../../../../components/ScrollTriggerControlBlocks'
//import PinControl from '../../../../components/PinControl'
import { AttributesCanvas2d } from '../../types';
import MediaGroupsManager from './media-groups-manager'
import WidthInput from '../../../../components/canvasxd/WidthInput';
import HeightInput from '../../../../components/canvasxd/HeightInput';

declare const wp: any; 
const { applyFilters, } = wp.hooks;

export default function InspectorControlsCanvas({
    clientId,
    attributes, 
    setAttributes, 
    defaultAttributes, 
    hasMediaGroups,
    indexActiveGroup,
    setIndexActiveGroup,
}:{
    clientId: string
    attributes: AttributesCanvas2d
    setAttributes: any
    defaultAttributes: any //AttributesCanvas2d
    hasMediaGroups: boolean
    indexActiveGroup: number
    setIndexActiveGroup: any
}){
    const { 
        width, 
        widthUnit,
        height, 
        heightUnit, 
    } = attributes

    const PlanF = applyFilters('scroll-sequence-testv2', <div style={{border: "1px solid yellow"}}>Free (v2)</div> );

    const parentClientNames = useSelect((select: any) => {
        const parentClientIds = select('core/block-editor').getBlockParents(clientId);
        return parentClientIds.map((id: string) => {
            const { name } = select('core/block-editor').getBlock(id) || {};
            return name;
        });
    }, [clientId]);
    const hasSceneAncestor =  parentClientNames.includes('scroll-sequence/v2-scene');


    return (
        <>
            <InspectorControls>
                <div>
                    <MediaGroupsManager 
                        attributes={attributes} 
                        setAttributes={setAttributes} 
                        //hasMediaGroups={hasMediaGroups}
                        indexActiveGroup={indexActiveGroup}
                        setIndexActiveGroup={setIndexActiveGroup}
                    />
                </div>

                {!hasSceneAncestor && 
                <Panel>
                    <PanelBody title={__("Animation Trigger", "scrollsequence")} initialOpen={true}>
                        <ScrollTriggerControlBlocks attributes={attributes} setAttributes={setAttributes} defaultAttributes={defaultAttributes} />
                    </PanelBody>
                </Panel>
                }

                {/* <Panel>
                    <PanelBody title={__("Pinning", "scrollsequence")} initialOpen={false}>
                        <PinControl attributes={attributes} setAttributes={setAttributes} defaultAttributes={defaultAttributes} />
                    </PanelBody>
                </Panel>      */}

                <Panel>
                    <PanelBody title={__("Debug ", "scrollsequence")} initialOpen={false}>
                        <p>Attributes:</p>
                        <pre>{JSON.stringify(attributes, null, 2)}</pre>
                        <p>Plan (filter):</p>
                        {PlanF}
                    </PanelBody>
                </Panel>        
            </InspectorControls>

            {/* <InspectorControls group="color">
                ____Color_____
            </InspectorControls> */}

            <InspectorControls group="dimensions">

                {/* DEFFAULTS: (this happens in three places. editor, editor component and front end render.php) */ }
                <WidthInput
                    value={ width ? width : '100'}
                    unit={ widthUnit ? widthUnit : '%'}
                    onChange={ ( newwidth:any ) =>
                        setAttributes( {
                            width: newwidth,
                        } )
                    }
                    onUnitChange={ ( nextUnit:any ) =>
                        setAttributes( {
                            widthUnit: nextUnit,
                        } )
                    }
                />                    
                <HeightInput
                    value={ height ? height : '75'}
                    unit={ heightUnit ? heightUnit : 'vh'}
                    onChange={ ( newheight:any ) =>
                        setAttributes( {
                            height: newheight,
                        } )
                    }
                    onUnitChange={ ( nextUnit:any ) =>
                        setAttributes( {
                            heightUnit: nextUnit,
                        } )
                    }
                />
            </InspectorControls>
        </>
    )
}
