import { useState } from 'react';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations
import { FocalPointPicker as WPFocalPointPicker } from '@wordpress/components';
import { DC2D } from '../../../../../../../dbg'
import getImageUrlFromPreSufix from '../../../../../../../shared/media-2d/utils';
//@ts-ignore: Cannot find name 'wp'.ts(2304)
const { useSelect } = wp.data;


export default function FocalPointPicker({ attributes, setAttributes, index}:any){

    function setFocalPoint(value:any){
        const newMediaGroups = [...attributes.mediaGroups]
        newMediaGroups[index].bgPosition = value
        setAttributes({mediaGroups: newMediaGroups})
    }

    switch (attributes.mediaGroups[index].type) {
        case 'wpMedia':  // imageIds
            const wpMediaMg = attributes.mediaGroups[index]
            //@ts-ignore: Cannot find name 'wp'.ts(2304)
            const wpMediaUrl = wp.data.select( 'core' ).getEntityRecord( 
                'postType',
                'attachment',
                wpMediaMg.images[0] 
            )?.source_url;
            
            DC2D&&console.log('wpMediaUrl',wpMediaUrl, 'wpMediaMg.images[0]',wpMediaMg.images[0])

            //Example function to render the CSS styles based on Focal Point Picker value
            const wpMediaStyle = {
                backgroundImage: wpMediaUrl && `url(${ wpMediaUrl })`,
                backgroundPosition: `${ wpMediaMg.bgPosition.x * 100 }% ${ wpMediaMg.bgPosition.y * 100 }%`,
            }; 

            return (
                <>
                    <WPFocalPointPicker
                        __nextHasNoMarginBottom
                        url={ wpMediaUrl }
                        value={wpMediaMg.bgPosition} //value={ focalPoint }
                        onDragStart={ (v:any)=>{setFocalPoint(v)} }
                        onDrag={ (v:any)=>{setFocalPoint(v)} }
                        onChange={ (v:any)=>{setFocalPoint(v)} }
                    />
                    <div style={ wpMediaStyle } />
                </>
            );

        case 'wpVideo': // videoId
            const wpVideoMg = attributes.mediaGroups[index]
            //@ts-ignore: Cannot find name 'wp'.ts(2304)
            const wpVideoUrl = wp.data.select( 'core' ).getEntityRecord( 
                'postType',
                'attachment',
                wpVideoMg.video 
            )?.source_url;     
            DC2D&&console.log('wpVideoMg',wpVideoMg, 'wpMediaMg.video',wpMediaMg.video)

            //Example function to render the CSS styles based on Focal Point Picker value
            const wpVideoStyle = {
                backgroundImage: wpVideoMg && `url(${ wpVideoMg })`,
                backgroundPosition: `${ wpVideoMg.bgPosition.x * 100 }% ${ wpVideoMg.bgPosition.y * 100 }%`,
            };                
            return (
                <>
                    <WPFocalPointPicker
                        __nextHasNoMarginBottom
                        //url={ wpVideoUrl }
                        value={attributes.mediaGroups[index].bgPosition} //value={ focalPoint }
                        onDragStart={ (v:any)=>{setFocalPoint(v)} }
                        onDrag={ (v:any)=>{setFocalPoint(v)} }
                        onChange={ (v:any)=>{setFocalPoint(v)} }
                    />
                    <div style={ wpVideoStyle } />            
                </>
            )            
        case 'urlList': // imageUrls
            const urlListMg = attributes.mediaGroups[index]
            const urlListFullUrl = getImageUrlFromPreSufix(urlListMg.images[0],urlListMg.prefix, urlListMg.suffix)
            const urlListStyle = {
                backgroundImage: `url(${ urlListFullUrl })`,
                backgroundPosition: `${ urlListMg.bgPosition.x * 100 }% ${ urlListMg.bgPosition.y * 100 }%`,
            }
            return (
                <>
                    <WPFocalPointPicker
                        __nextHasNoMarginBottom
                        url={ urlListFullUrl }
                        value={urlListMg.bgPosition} //value={ focalPoint }
                        onDragStart={ (v:any)=>{setFocalPoint(v)} }
                        onDrag={ (v:any)=>{setFocalPoint(v)} }
                        onChange={ (v:any)=>{setFocalPoint(v)} }
                    />
                    <div style={ urlListStyle } />            
                </>                
            )        
        case 'urlVideo': // videoUrl
            const urlVideo = attributes.mediaGroups[index].video
            const urlVideoStyle = {
                backgroundImage: `url(${ urlVideo })`,
                backgroundPosition: `${ attributes.mediaGroups[index].bgPosition.x * 100 }% ${ attributes.mediaGroups[index].bgPosition.y * 100 }%`,
            };     
            return (
                <>
                    <WPFocalPointPicker
                        __nextHasNoMarginBottom
                        //url={ urlVideo }
                        value={attributes.mediaGroups[index].bgPosition} //value={ focalPoint }
                        onDragStart={ (v:any)=>{setFocalPoint(v)} }
                        onDrag={ (v:any)=>{setFocalPoint(v)} }
                        onChange={ (v:any)=>{setFocalPoint(v)} }
                    />
                    <div style={ urlVideoStyle } />            
                </>
            )                   
        default:
            return (
                <>Error: Unknown media group type in focal point picker</>
            ); 
    }
};

