import { useState } from 'react';
//@ts-ignore
import { Button, Modal, Spinner } from '@wordpress/components';
import { close } from '@wordpress/icons';

import { useToolsContext } from './ContextProvider';
import { actionGenerate } from './actionGenerate';

import { IconSparkle } from '../../../../../icons'

export default function GenerateAbortButtons({ disabled = false, cost }: { disabled?: boolean, cost?: number }) {

    const { progress: {  busy, updateProgress}, activeIo } = useToolsContext();
    const toolsState = useToolsContext();

    const [showCancelDialog, setShowCancelDialog] = useState(false);


    function handleAbortClick() {
        setShowCancelDialog(true);
    }

    function handleConfirmCancel() {
        updateProgress({ busy: false, log: { level: 'warning', message: 'User cancelled generation.' } });
        setShowCancelDialog(false);
    }

    function handleContinueWaiting() {
        setShowCancelDialog(false);
    }

    return (
        <>
            <div>
                {busy && (
                    <Button
                        icon={close}
                        isDestructive
                        variant="secondary"
                        onClick={handleAbortClick}
                        style={{ marginLeft: 12, marginRight: 12 }}
                    />
                )}
                <Button
                    variant={`${(activeIo === 'input') ? 'primary' : 'secondary'}`}
                    icon={ (busy === 'generating' || busy === 'uploading') ? undefined  : <IconSparkle width={16} height={16} /> }
                    onClick={()=>{
                        actionGenerate(toolsState);
                    }}
                    disabled={ busy || disabled }
                >
                    { busy 
                        ? 
                        <>
                            <Spinner style={{width: '16px', height: '16px', marginTop:0, marginLeft:0}} />
                            { busy === 'generating' && 'Generating...'}
                            { busy === 'uploading' && 'Uploading...'}
                        </>
                        : `Generate ${cost ? ` (${cost} credits)` : ''}`
                    }
                </Button>
            </div>       
            {showCancelDialog && (
                <Modal
                    title="Cancel Generation?"
                    onRequestClose={handleContinueWaiting}
                >
                    <p>
                        You can cancel now, but the job may still complete and use credits. Results will be available in your dashboard history.
                    </p>
                    <Button
                        variant="secondary"
                        onClick={handleConfirmCancel}
                        style={{ marginRight: 8 }}
                    >
                        Cancel Generation
                    </Button>
                    <Button
                        variant="primary"
                        onClick={handleContinueWaiting}
                    >
                        Continue Waiting
                    </Button>
                </Modal>
            )}
        </>        
    )
}