import type { Img2ImgModelContextFx, Img2ImgModelContextNb, Img2VidModelContextHlo, Img2VidModelContextKdp, Vid2SsqModelContextLocal } from "./types";

// fx
export const IMG2IMG_MODEL_INITIAL_STATE_FX : Img2ImgModelContextFx = {
    local: {
    },
    input: {
        prompt: '',
        num_images: 1,
        output_format: 'jpeg',
        enhance_prompt: false,
        aspect_ratio: undefined,
        image_url: '', // this is the s3 URL
    }
} 
export const IMG2IMG_MODEL_FX = {
    id: 'fx',
    title: 'Flux Kontext',
    description: 'Transform existing images into stunning visuals. Specify what you want to change and Kontext will follow. It is capable of understanding the context of the image, making it easier to edit them without having to describe in details what you want to do.',
    config: {
        num_imagesOptions: [1, 2, 4] as const,
        output_formatOptions: ['jpeg', 'png'] as const, 
        aspect_ratioOptions: [ undefined, "21:9", "16:9", "4:3", "3:2", "1:1", "2:3", "3:4", "9:16", "9:21" ] as const,
        image_urlLabel: 'Input Image',
        costPerOutput: 20,
    },
    initialState : IMG2IMG_MODEL_INITIAL_STATE_FX
}
// nb
export const IMG2IMG_MODEL_INITIAL_STATE_NB : Img2ImgModelContextNb = {
    local: {
    },
    input: {
        prompt: '',
        image_urls: [], // this is the s3 URL
        num_images: 1,
        output_format: 'jpeg',
        aspect_ratio: undefined,
    }
} 
export const IMG2IMG_MODEL_NB = {
    id: 'nb',
    title: 'Nano Banana',
    description: 'Edit multiple images using Gemini.',
    config: {
        image_urlLabels: ['Input Image', 'Additional Image'] as const,
        num_imagesOptions: [1, 2, 4] as const,
        output_formatOptions: ['jpeg', 'png'] as const, 
        aspect_ratioOptions: [ undefined, "21:9", "1:1", "4:3", "3:2", "2:3", "5:4", "4:5", "3:4", "16:9", "9:16" ] as const,
        costPerOutput: 20,
    },
    initialState : IMG2IMG_MODEL_INITIAL_STATE_NB
}

export const TOOL_IMG2IMG = {
    id: 'img2img',
    title: 'Image to Image',
    description: 'Transform an input image into a new image using AI models.',
    // activeModelId: 'fx', // this is state, really - not in registry
    models: [
        IMG2IMG_MODEL_FX,
        IMG2IMG_MODEL_NB,
    ]
};

// hlo
export const IMG2VID_MODEL_INITIAL_STATE_HLO : Img2VidModelContextHlo = {
    local: {
    },
    input: {
        prompt: '',
        image_url: '', // this is the s3 URL
        prompt_optimizer: true,
        end_image_url: undefined,
    }
}
export const IMG2VID_MODEL_HLO = {
    id: 'hlo',
    title: 'Hailuo',
    description: 'A model specialized in generating videos from images. Add a starting image and/or ending image to create a smooth transition video.',
    config: {
        image_urlLabel: 'Start Frame',
        end_image_urlLabel: 'End Frame (optional)',
        costPerOutput: 250,
    },
    initialState : IMG2VID_MODEL_INITIAL_STATE_HLO
};
// kdp
export const IMG2VID_MODEL_INITIAL_STATE_KDP : Img2VidModelContextKdp = {
    local: {    
    },
    input: { 
        prompt: '',
        image_url: '', 
        duration: 10,
        negative_prompt: 'motion blur, blur, distort, and low quality',
    }
}

export const IMG2VID_MODEL_KDP =  {
    id: 'kdp',
    title: 'Kling',
    description: 'Another model for image to video conversion.',
    config: {
        image_urlLabel: 'Start Frame',
        durationOptions: [5, 10] as const,
        costPerOutput: 250,
    },
    initialState : IMG2VID_MODEL_INITIAL_STATE_KDP
};

export const TOOL_IMG2VID = {
    id: 'img2vid',
    title: 'Image to Video',
    description: 'Create a video from an input image using AI models.',
    models: [
        IMG2VID_MODEL_HLO,
        IMG2VID_MODEL_KDP,
    ]
}

// local (vid2ssq)
export const VID2SSQ_MODEL_INITIAL_STATE_LOCAL : Vid2SsqModelContextLocal = {
    local: {
    },
    input: {
        video_url: '',  // this is the s3 URL
        prefix: '',
        quality: 5,
        downsize: true,
        
    }
};
export const VID2SSQ_MODEL_LOCAL = {
    id: 'local',
    title: 'Local FFmpeg',
    description: 'A local model for video to image sequence conversion.',
    config: {
        qualityOptions: [
            15, // aggressive
            5,  // optimal
            2,  // original
            // { label: 'Aggressive compression (lossy)', value: 'aggressive' as Vid2SsqQualityOptions, number: 15 },
            // { label: 'Optimal compression (recommended)', value: 'optimal' as Vid2SsqQualityOptions, number: 5 },
            // { label: 'Original (no compression)', value: 'original' as Vid2SsqQualityOptions, number: 2 },
        ] as const,
        downsizeOptions: [
            true, // downsize
            false, // no downsize
            //{ label: 'Downsize to fit inside 1920x1080px rectangle (recommended)', value: true },
            //{ label: 'No resize', value: false },
        ] as const,
        maxFrames: 2000,
        costPerOutput: 0, 
    },
    initialState : VID2SSQ_MODEL_INITIAL_STATE_LOCAL
};
// cloud (vid2ssq) - not implemented yet
export const VID2SSQ_MODEL_INITIAL_STATE_CLOUD = {
    local: {
    },
    input: {
        //prefix: '',
        //api_key: '',
    }
};
export const VID2SSQ_MODEL_CLOUD = {
    id: 'cloud',
    title: 'Cloud Service',
    description: 'A cloud-based model for video to image sequence conversion.',
    config: {
        //apiKeyLabel: 'API Key',
    },
    initialState : VID2SSQ_MODEL_INITIAL_STATE_CLOUD
};

export const TOOL_VID2SSQ = {
    id: 'vid2ssq',
    title: 'Video to Scrollsequence',
    description: 'Transform a video into a scroll sequence using AI models.',
    // activeModelId: 'local', // this is state, really - not in registry
    models: [
        VID2SSQ_MODEL_LOCAL,
        VID2SSQ_MODEL_CLOUD,
    ]
};

export const TOOL_REGISTRY  = [
    TOOL_IMG2IMG,
    TOOL_IMG2VID,
    TOOL_VID2SSQ
];

