//@ts-ignore
import { SelectControl } from '@wordpress/components';

export default function NumberOfOutputsControl<T extends readonly number[]>({
    value,
    options,
    onChange,
}: {
    value: T[number];
    options: T;
    onChange: (newValue: T[number]) => void;
}) {
    return (
        <SelectControl
            label="Number of Outputs"
            value={value.toString()}
            options={options.map(opt => ({
                label: opt.toString(),
                value: opt.toString(),
            }))}
            onChange={(newValue:number) => onChange(Number(newValue) as T[number])}
            __next40pxDefaultSize
            __nextHasNoMarginBottom
        />
    );
}