//@ts-ignore
import { __ } from '@wordpress/i18n';
//@ts-ignore
import { SelectControl } from '@wordpress/components';

type OutputFormatProps<T extends string> = {
    onChange: (newValue: T) => void;
    value: T;
    options: ReadonlyArray<T>;
};

export default function OutputFormat<T extends string>({
    onChange,
    value,
    options
}: OutputFormatProps<T>) {
    const optionsMap = options.map(format => ({
        label: format.toUpperCase(),
        value: format,
    }));

    return (
        <SelectControl
            label={__("Output format", "scrollsequence")}
            value={value}
            options={optionsMap}
            onChange={(val: T) => val && onChange(val as T)} // SelectControl's onChange gives string | undefined, so cast to T
            __next40pxDefaultSize
            __nextHasNoMarginBottom
        />
    );
}