//@ts-ignore
import { SelectControl } from '@wordpress/components';

import { useImg2ImgContext, useToolsContext } from '../../ContextProvider';
import { TOOL_IMG2IMG } from '../../constants'
import type { Img2ImgModelIds } from '../../types';

import ModelDisplayFx from './models/ModelDisplayFx';
import ModelDisplayNb from './models/ModelDisplayNb';

export default function ToolImg2Img() {
    const { currentModelId, setCurrentModelId,  } = useImg2ImgContext();

    const options = TOOL_IMG2IMG.models.map( model => ( {
        label: model.title,
        value: model.id,
    } ) );
    const currentModel = TOOL_IMG2IMG.models.find(m => m.id === currentModelId)!;

    return (
        <div>
            <SelectControl
                label="Model"
                value={ currentModel.id }
                help= { currentModel.description }
                options={ options }
                onChange={ ( newModelId: Img2ImgModelIds ) => {
                    setCurrentModelId(newModelId);
                }}
                __next40pxDefaultSize
                __nextHasNoMarginBottom
            />
                {
                    currentModelId === 'fx' ? <ModelDisplayFx /> :
                    currentModelId === 'nb' ? <ModelDisplayNb /> :
                    <div>Unknown model selected</div>
                }
        </div>
    )
}