//@ts-ignore
import { TextareaControl, Button, Flex, FlexItem, ToggleControl} from '@wordpress/components';
import { useImg2ImgContext, useToolsContext } from '../../../ContextProvider';

import OutputFormatControl from '../../../to-be-shared/OutputFormatControl';
import NumberOfOutputsControl from '../../../to-be-shared/NumberOfOutputsControl';
import InputImagesControl from '../../../to-be-shared/InputImageControl';
import AspectRatioControl from '../../../to-be-shared/AspectRatioControl';

import { IMG2IMG_MODEL_FX } from '../../../constants'
import type { Img2ImgModelContextFx, ToolsContextType } from '../../../types';
import GenerateAbortButtons from '../../../GenerateAbortButtons';


export default function ModelDisplayFx() {
    const { progress } = useToolsContext();
    const { models  } = useImg2ImgContext();

    const modelFx = models.find(model => model.id === 'fx')!;
    const modelState = modelFx.modelState;
    const setModelState = modelFx.setModelState;

    // Determine if we can generate
    const canGenerate = Boolean(modelState.input.image_url && modelState.input.prompt);

    return (
        <>
            <InputImagesControl
                label={IMG2IMG_MODEL_FX.config.image_urlLabel}
                progress={progress}

                imageS3Url={modelState.input.image_url}

                onUploadFinished={(s3Url: string, fileName: string) => {
                    console.log('ModelDisplayFx handleUploadComplete() s3Urls:', s3Url);
                    setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            image_url: s3Url
                        }
                    }));
                }}
                onRemove={() => {
                    console.log('ModelDisplayFx handleRemoveMedia() ');
                    setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            image_url: ''
                        }
                    }));
                }}
            />

            <TextareaControl
                label="Prompt"
                value={modelState.input.prompt}
                onChange={(newPrompt: string) => {
                    setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            prompt: newPrompt
                        }
                    }));
                }}
                rows={3}
            />

            <ToggleControl
                __nextHasNoMarginBottom
                label="Enhance Prompt"
                help={
                    modelState.input.enhance_prompt
                        ? 'Use enhanced prompt.'
                        : 'No prompt enhancement..'
                }
                checked={ modelState.input.enhance_prompt }
                style={{ marginBottom: '10rem' }}
                onChange={ (newValue:boolean) => {
                        setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                            ...prev,
                            input: {
                                ...prev.input,
                                enhance_prompt: newValue
                            }
                        }));
                } }
            />

            <Flex gap={2} align="flex-end" style={{ marginBottom: '1rem', marginTop: '1rem' }}>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <OutputFormatControl
                        value={modelState.input.output_format}
                        onChange={(newFormat) => {
                            setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    output_format: newFormat
                                }
                            }));
                        }}
                        options={IMG2IMG_MODEL_FX.config.output_formatOptions}
                    />  
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>                 
                    <NumberOfOutputsControl
                        value={modelState.input.num_images}
                        options={IMG2IMG_MODEL_FX.config.num_imagesOptions}
                        onChange={(newNumOutputs) => {
                            setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    num_images: newNumOutputs
                                }
                            }));
                        }}
                    />              
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <AspectRatioControl
                        value={modelState.input.aspect_ratio}
                        onChange={(newAspectRatio) => {
                            setModelState( ( prev : Img2ImgModelContextFx ) : Img2ImgModelContextFx => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    aspect_ratio: newAspectRatio
                                }
                            }));
                        }}
                        options={IMG2IMG_MODEL_FX.config.aspect_ratioOptions}
                    />
                </FlexItem>
            </Flex>

            <p> This model typically takes only a few seconds to complete.</p>
            
            <div style={{ display: 'flex', justifyContent: 'flex-end', marginBottom: '1rem' }}>
                <GenerateAbortButtons disabled={!canGenerate} cost={IMG2IMG_MODEL_FX.config.costPerOutput * modelState.input.num_images} />
            </div>

        </>
    );
}




