import { useState } from "react";


import type { Img2ImgModelIds, ToolImg2ImgContextState, Img2ImgModelContextFx, Img2ImgModelContextNb  } from "../../types";
import { IMG2IMG_MODEL_INITIAL_STATE_FX, IMG2IMG_MODEL_INITIAL_STATE_NB } from "../../constants";

// State hook
export function useImg2ImgState(): ToolImg2ImgContextState {
  // Current model
  const [ currentModelId, setCurrentModelId ] = useState<Img2ImgModelIds>("fx");

  // State for each model
  const [ modelStateFx, setModelStateFx ] = useState<Img2ImgModelContextFx>(IMG2IMG_MODEL_INITIAL_STATE_FX);
  const [ modelStateNb, setModelStateNb ] = useState<Img2ImgModelContextNb>(IMG2IMG_MODEL_INITIAL_STATE_NB );

  return {
    id: 'img2img',
    currentModelId, 
    setCurrentModelId,
    models: [
      {
        id: 'fx',
        modelState: modelStateFx, 
        setModelState: setModelStateFx,
      },
      {
        id: 'nb',
        modelState: modelStateNb, 
        setModelState: setModelStateNb,
      }
    ]
  };
}
