//@ts-ignore
import { SelectControl } from '@wordpress/components';

import { useImg2VidContext, useToolsContext } from '../../ContextProvider';
import { TOOL_IMG2VID } from '../../constants'
import type { Img2VidModelIds } from '../../types';

import ModelDisplayHlo from './models/ModelDisplayHlo';
import ModelDisplayKdp from './models/ModelDisplayKdp';

export default function ToolImg2Vid() {
    const { currentModelId, setCurrentModelId,  } = useImg2VidContext();

    const options = TOOL_IMG2VID.models.map( model => ( {
        label: model.title,
        value: model.id,
    } ) );
    const currentModel = TOOL_IMG2VID.models.find(m => m.id === currentModelId)!;

    return (
        <div>
            <SelectControl
                label="Model"
                value={ currentModel.id }
                help= { currentModel.description }
                options={ options }
                onChange={ ( newModelId: Img2VidModelIds ) => {
                    setCurrentModelId(newModelId);
                }}
                __next40pxDefaultSize
                __nextHasNoMarginBottom
            />
                {
                    currentModelId === 'hlo' ? <ModelDisplayHlo /> :
                    currentModelId === 'kdp' ? <ModelDisplayKdp /> :
                    <div>Unknown model selected</div>
                }
        </div>
    )
}