//@ts-ignore
import { TextareaControl, Button, Flex, FlexItem, ToggleControl} from '@wordpress/components';
import { useImg2VidContext, useToolsContext } from '../../../ContextProvider';

import InputImagesControl from '../../../to-be-shared/InputImageControl';

import { IMG2VID_MODEL_HLO } from '../../../constants'
import type { Img2VidModelContextHlo } from '../../../types';
import GenerateAbortButtons from '../../../GenerateAbortButtons';

export default function ModelDisplayHlo() {
    const { progress } = useToolsContext();
    const { models  } = useImg2VidContext();

    const modelHlo = models.find(model => model.id === 'hlo')!;
    const modelState = modelHlo.modelState;
    const setModelState = modelHlo.setModelState;

    // Determine if we can generate (we need the start image and a prompt)
    const canGenerate = Boolean(modelState.input.image_url && modelState.input.prompt);

    return (
        <>
            <Flex gap={2} align="flex-end" style={{ marginBottom: '1rem' }} justify="start">
                <FlexItem style={{ minWidth: 100 }}>
                    <InputImagesControl
                        label={IMG2VID_MODEL_HLO.config.image_urlLabel}
                        progress={progress}

                        imageS3Url={modelState.input.image_url}

                        onUploadFinished={(s3Url: string, fileName: string) => {
                            console.log('ModelDisplayHlo handleUploadComplete() s3Urls:', s3Url);
                            setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    image_url: s3Url
                                }
                            }));
                        }}
                        onRemove={() => {
                            console.log('ModelDisplayHlo handleRemoveMedia() ');
                            setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    image_url: ''
                                }
                            }));
                        }}
                    />
                </FlexItem>
                <FlexItem style={{ flex: 1, minWidth: 100 }}>
                    <InputImagesControl
                        label={IMG2VID_MODEL_HLO.config.end_image_urlLabel}
                        progress={progress}

                        imageS3Url={modelState.input.end_image_url ?? ''}

                        onUploadFinished={(s3Url: string, fileName: string) => {
                            console.log('ModelDisplayHlo handleUploadComplete() s3Urls:', s3Url);
                            setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    end_image_url: s3Url ? s3Url : undefined
                                }
                            }));
                        }}
                        onRemove={() => {
                            console.log('ModelDisplayHlo handleRemoveMedia() ');
                            setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                                ...prev,
                                input: {
                                    ...prev.input,
                                    end_image_url: undefined
                                }
                            }));
                        }}
                    />
                </FlexItem>                
            </Flex>

            <TextareaControl
                label="Prompt"
                value={modelState.input.prompt}
                onChange={(newPrompt: string) => {
                    setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                        ...prev,
                        input: {
                            ...prev.input,
                            prompt: newPrompt
                        }
                    }));
                }}
                rows={3}
            />

            <ToggleControl
                __nextHasNoMarginBottom
                label="Enhance Prompt"
                help={
                    modelState.input.prompt_optimizer
                        ? 'Use prompt optimizer.'
                        : 'No prompt optimizer.'
                }
                checked={ modelState.input.prompt_optimizer }
                style={{ marginBottom: '1rem' }}
                onChange={ (newValue:boolean) => {
                        setModelState( ( prev : Img2VidModelContextHlo ) : Img2VidModelContextHlo => ( {
                            ...prev,
                            input: {
                                ...prev.input,
                                prompt_optimizer: newValue
                            }
                        }));
                } }
            />

            <p>This model creates 5 seconds long clips. Job completes in around 2-3 minutes.</p>

            <div style={{ display: 'flex', justifyContent: 'flex-end', marginBottom: '1rem' }}>
                <GenerateAbortButtons disabled={!canGenerate} cost={IMG2VID_MODEL_HLO.config.costPerOutput}  />
            </div>

        </>
    );
}




