//@ts-ignore
import { SelectControl } from '@wordpress/components';

import { useVid2SsqContext, useToolsContext } from '../../ContextProvider';
import { TOOL_VID2SSQ } from '../../constants'
import type { Vid2SsqModelIds } from '../../types';

import ModelDisplayLocal from './models/ModelDisplayLocal';
//import ModelDisplayCloud from './models/ModelDisplayCloud';

export default function ToolVid2Ssq() {
    const { currentModelId, setCurrentModelId,  } = useVid2SsqContext();

    const options = TOOL_VID2SSQ.models.map( model => ( {
        label: model.title,
        value: model.id,
        disabled: model.id==='cloud' ? true : false, // disable cloud for now
    } ) );
    const currentModel = TOOL_VID2SSQ.models.find(m => m.id === currentModelId)!;

    return (
        <div>
            <SelectControl
                label="Model"
                value={ currentModel.id }
                help= { currentModel.description }
                options={ options }
                onChange={ ( newModelId: Vid2SsqModelIds ) => {
                    setCurrentModelId(newModelId);
                }}
                __next40pxDefaultSize
                __nextHasNoMarginBottom
            />
                {
                    currentModelId === 'local' ? <ModelDisplayLocal /> :
                    //currentModelId === 'cloud' ? <ModelDisplayCloud /> :
                    currentModelId === 'cloud' ? <div>ModelDisplayCloud (coming soon!)</div> :
                    <div>Unknown model selected</div>
                }
        </div>
    )
}