import { useState } from "react";


import type { Vid2SsqModelIds, ToolVid2SsqContextState, Vid2SsqModelContextLocal, Vid2SsqModelContextCloud  } from "../../types";

import { VID2SSQ_MODEL_INITIAL_STATE_LOCAL, VID2SSQ_MODEL_INITIAL_STATE_CLOUD } from "../../constants";

// State hook
export function useVid2SsqState(): ToolVid2SsqContextState {
  // Current model
  const [ currentModelId, setCurrentModelId ] = useState<Vid2SsqModelIds>("local");

  // State for each model
  const [ modelStateLocal, setModelStateLocal ] = useState<Vid2SsqModelContextLocal>(VID2SSQ_MODEL_INITIAL_STATE_LOCAL);
  const [ modelStateCloud, setModelStateCloud ] = useState<Vid2SsqModelContextCloud>(VID2SSQ_MODEL_INITIAL_STATE_CLOUD);

  return {
    id: 'vid2ssq',
    currentModelId, 
    setCurrentModelId,
    models: [
      {
        id: 'local',
        modelState: modelStateLocal, 
        setModelState: setModelStateLocal,
      },
      {
        id: 'cloud',
        modelState: modelStateCloud, 
        setModelState: setModelStateCloud,
      }
    ]
  };
}
