//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
import {  useEffect, useRef, useState } from '@wordpress/element'

import { 
    useBlockProps, 
    useInnerBlocksProps, 
    store as blockEditorStore, 
    //@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
} from '@wordpress/block-editor';

//@ts-ignore: Cannot find module '@wordpress/data' or its corresponding type declarations.
import { useSelect } from '@wordpress/data';

import { AttributesContainer } from '../types';

import InspectorControls from './inspector-controls';
import BlockControlsContainer from './block-controls';
import getScrollsequenceFop from '../../../getScrollsequenceFop';
import { DCNT } from '../../../../dbg'
/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {WPElement} Element to render.
 */
interface EditProps {
    clientId: string,
    attributes: AttributesContainer,
    setAttributes: any,
    name: string,
    onRemove: any, //  () => removeBlock(clientId)
    onReplace: any, //  (...args) => {…}
    // ... more attributes
    
}
export default function Edit(props:EditProps) {

	const { 
		clientId,
		attributes, 
		setAttributes,
		attributes:{
			minHeight, 
			minHeightUnit, 
		    //... more attributes
		} 
	} = props;

	const defaultAttributes = useSelect((select:any) => { // Access the default values
		return select('core/blocks').getBlockType('scroll-sequence/v2-container').attributes
	}, []); //console.log('defaultAttributes',defaultAttributes)

    const minHeightWithUnit =
    minHeight && minHeightUnit
        ? `${ minHeight }${ minHeightUnit }`
        : minHeight;

    const elRef = useRef<any>(null)
    const blockProps = useBlockProps({
        style: {
            minHeight: minHeightWithUnit,
            overflowX: "clip", // new
        },        
        className: `ssq-relative`,
        ref: elRef
    });
    const { children, ...innerBlocksProps } = useInnerBlocksProps( blockProps, {
        // TEMPLATE CAN BE ADDED HERE 
    } );

    useEffect(() => {
        //DCNT&&
        console.log('container useEffect [attributes]')
        getScrollsequenceFop(elRef.current)?.createBlock(elRef.current)
        return () => {
            console.log('container useEffect[attributes] CLEANUP')
            getScrollsequenceFop(elRef.current)?.destroyBlock(elRef.current)
        };
    }, [attributes]);	

    return (
        <>
            <BlockControlsContainer
                clientId={clientId}
                attributes={attributes} 
                setAttributes={setAttributes} 
            />

            <InspectorControls 
                attributes={attributes} 
                setAttributes={setAttributes} 
                defaultAttributes={defaultAttributes} 
                //hasImageGroups={hasImageGroups}
            />        
            <div {...innerBlocksProps} data-ssq-container={JSON.stringify(attributes)}  >
                { children }
            </div>
        </>
    )
}


/*

// EMPTY STATE 

    // const hasInnerBlocks = useSelect((select:any) => { // AI ? 
    //     return select(blockEditorStore).getBlockCount(clientId) > 0;
    // }, [clientId]);

            { !hasInnerBlocks ? (
                <div {...blockProps}>
                    <Placeholder
                        icon="layout"
                        instructions={__('Start from a template or use AI to generate','scrollsequence')}
                        label={__('Scrollsequence','scrollsequence')}                    
                    >
                        <h2>Templates (Dropdown with some previews)</h2>
                        <ul>
                            <li>
                                2D Sticky Canvas
                            </li>
                            <li>
                                2D Fixed Canvas 
                            </li>          
                            <li>
                                3D Sticky Canvas
                            </li>
                            <li>
                                3D Fixed Canvas
                            </li>                  
                        </ul>

                        <h2>AI Agent</h2>
                        <iframe 
                            src="https://api.scrollsequence.com/ai-agent"
                            width="100%"
                            height="500px"
                            style={{border: 'none'}}
                        ></iframe>
                    </Placeholder>
                </div>
            ) : (
                <div {...innerBlocksProps} data-ssq-container={JSON.stringify(attributes)}  >
                    { children }
                </div>
            )} 


*/