//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/element' or its corresponding type declarations.
import { useMemo } from '@wordpress/element';
import { 
    InspectorControls, 
    useSettings, 
    //@ts-ignore: Cannot find module '@wordpress/block-editor' or its corresponding type declarations.
} from '@wordpress/block-editor';
import { 
    Panel, 
    PanelBody, 
    SelectControl,
    Notice,
    __experimentalParseQuantityAndUnitFromRawValue as parseQuantityAndUnitFromRawValue,
    __experimentalUseCustomUnits as useCustomUnits,
    __experimentalUnitControl as UnitControl, 
    //@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
} from '@wordpress/components'

import { AttributesContainer } from '../../types';

//@ts-ignore: Cannot find name 'wp'.
const { applyFilters } = wp.hooks;


function SimpleHeightInput( { 
    onChange,
    onUnitChange,
    unit = 'px',
    value = '',
} :any ) {
    // Simplified WP Function from Cover Block (see: CoverHeightInput)
    // Compared to Cover block -> itdoes not have the option in the parent "dimensions" tab to reset, but it is simpler. ( no clientId is needed)
    const isPx = unit === 'px';
    const [ availableUnits ] = useSettings( 'spacing.units' );
    const units = useCustomUnits( {
        availableUnits: availableUnits || [ 'px', 'em', 'rem', 'vw', 'vh' ],
        defaultValues: { px: 430, '%': 20, em: 20, rem: 20, vw: 20, vh: 50 },
    } );

    const handleOnChange = ( unprocessedValue:any ) => {
        const inputValue =
            unprocessedValue !== ''
                ? parseFloat( unprocessedValue )
                : undefined;

        if ( isNaN( inputValue! ) && inputValue !== undefined ) {
            return;
        }
        onChange( inputValue );
    };

    const computedValue = useMemo( () => {
        const [ parsedQuantity ] = parseQuantityAndUnitFromRawValue( value );
        return [ parsedQuantity, unit ].join( '' );
    }, [ unit, value ] );

    const MIN_HEIGHT = 50;
    const min = isPx ? MIN_HEIGHT : 0;

    return (
        <UnitControl
            __next40pxDefaultSize
            label={ __( 'Minimum height', 'scrollsequence' ) }
            //id={ inputId }
            isResetValueOnUnitChange
            min={ min }
            onChange={ handleOnChange }
            onUnitChange={ onUnitChange }
            units={ units }
            value={ computedValue }
        />
    );
}

export default function InspectorControlsC2d({
    attributes, 
    setAttributes, 
    defaultAttributes, 
}:{
    attributes: AttributesContainer
    setAttributes: any
    defaultAttributes: any 
}){
    const { 
        minHeight, 
        minHeightUnit, 
        tagName
    } = attributes

    
    return (
        <>
            <InspectorControls>
                <Panel>
                    <PanelBody title={__("Debug ", "scrollsequence")} initialOpen={false}>
                        <p>Attributes:</p>
                        <pre>{JSON.stringify(attributes, null, 2)}</pre>
                    </PanelBody>
                </Panel>        
            </InspectorControls>

            <InspectorControls group="dimensions">
                <SimpleHeightInput
                    value={
                        attributes?.style?.dimensions?.aspectRatio
                            ? ''
                            : minHeight
                    }
                    unit={ minHeightUnit }
                    onChange={ ( newMinHeight:any ) =>
                        setAttributes( {
                            minHeight: newMinHeight,
                        } )
                    }
                    onUnitChange={ ( nextUnit:any ) =>
                        setAttributes( {
                            minHeightUnit: nextUnit,
                        } )
                    }
                />
            </InspectorControls>

            <InspectorControls group="advanced">
                    div/section/bla
            </InspectorControls>
        </>
    )
}
