<?php
/**
 * PHP file to use when rendering the block type on the server to show on the front end.
 *
 * The following variables are exposed to the file:
 *     $attributes (array): The block attributes.
 *     $content (string): The block default content.
 *     $block (WP_Block): The block instance.
 *
 * @see https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/block-api/block-metadata.md#render
 */

// RENDER FUNCTION
require_once plugin_dir_path(dirname(__DIR__, 3)) . 'blocks-v2-scene-render-fns.php'; // 3 levels up
$render_atts = ssq_render_scene_variation($attributes);

// CONTENT
?>

<?php //echo '<h1>'.$block->inner_blocks->count().'</h1>'; ?>

<?php echo $render_atts['before'] ?>
    <?php echo ssq_get_wrapped_content($block); ?>
    <?php //echo $content; // Something says to me, this should be escaped.  ?>
    <?php //echo esc_html( $content ); // Escape the content to prevent XSS  ?>
<?php echo $render_atts['after'] ?>





