//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
import { PanelRow, ToggleControl, RangeControl } from '@wordpress/components'

export default function ScrollTriggerControlHocs({
    attributes, 
    setAttributes, 
}: {
    attributes: {
        ssqAnimateOnScroll?:{
            to?: any, 
            st?: {
                triggerStart?: number,
                triggerEnd?: number,
                scrub?: number, // scrub should also be "false" and then we have a few options to set the toggle actions. 
                markers?: boolean
            }
        }
    },
    setAttributes: any
}){

    const triggerStartDefault = 0.5
    const triggerEndDefault = 0.5
    const scrubDefault = 1
    const markersDefault = false

    return (
		<>
			<PanelRow>
				<ToggleControl
					__nextHasNoMarginBottom
					label={__("Show Markers", "scrollsequence")}
					checked={ attributes.ssqAnimateOnScroll?.st?.markers || markersDefault }
					onChange={ () => {
                        setAttributes({
                            ssqAnimateOnScroll: {
                                ...attributes.ssqAnimateOnScroll,
                                st: {
                                    ...attributes.ssqAnimateOnScroll?.st,
                                    markers: !attributes.ssqAnimateOnScroll?.st?.markers
                                }
                            }
                        });
                    }}
				/>
			</PanelRow>
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how early you want the animation to start.", "scrollsequence")}
                    initialPosition={attributes.ssqAnimateOnScroll?.st?.triggerStart || triggerStartDefault}
					label={__("Trigger Start", "scrollsequence")}
					min={0}
					max={1}
					step={0.01}
					onChange={(value: number) => { 
                        setAttributes({
                            ssqAnimateOnScroll: {
                                ...attributes.ssqAnimateOnScroll,
                                st: {
                                    ...attributes.ssqAnimateOnScroll?.st,
                                    triggerStart: value
                                }
                            }
                        });
					}}
					allowReset={true}
					resetFallbackValue={triggerStartDefault}			
					marks={[
						{
							label: '',
							value: triggerStartDefault
						}
					]}							
				/>
			</PanelRow>
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how late you want the animation to finish.", "scrollsequence")}
					initialPosition={attributes.ssqAnimateOnScroll?.st?.triggerEnd || triggerEndDefault}
					label={__("Trigger End", "scrollsequence")}
					min={0}
					max={1}
					step={0.01}
					onChange={(value:number) => { 
                        setAttributes({
                            ssqAnimateOnScroll: {
                                ...attributes.ssqAnimateOnScroll,
                                st: {
                                    ...attributes.ssqAnimateOnScroll?.st,
                                    triggerEnd: value
                                }
                            }
                        });
					}}
					allowReset={true}
					resetFallbackValue={triggerEndDefault}			
					marks={[
						{
							label: '',
							value: triggerEndDefault
						}
					]}							
				/>						
			</PanelRow>
			<PanelRow>
				<RangeControl
					__nextHasNoMarginBottom
					help={__("Please select how smooth you want your animation.", "scroll-sequence")}
					initialPosition={attributes.ssqAnimateOnScroll?.st?.scrub || scrubDefault}
					label={__("Smoothness (delay in seconds)", "scroll-sequence")}
					min={0}
					max={5}
					step={0.01}
					onChange={(value:number) => { 
                        setAttributes({
                            ssqAnimateOnScroll: {
                                ...attributes.ssqAnimateOnScroll,
                                st: {
                                    ...attributes.ssqAnimateOnScroll?.st,
                                    scrub: value
                                }
                            }
                        });
					}}
					allowReset={true}
					resetFallbackValue={scrubDefault}		
					marks={[
						{
							label: '',
							value: scrubDefault
						}
					]}					
				/>
			</PanelRow>
		</>
    )
}
