//@ts-ignore: Cannot find module '@wordpress/i18n' or its corresponding type declarations.
import { __ } from '@wordpress/i18n';
//@ts-ignore: Cannot find module '@wordpress/element' or its corresponding type declarations.
import { useMemo } from '@wordpress/element';
import { 
    __experimentalParseQuantityAndUnitFromRawValue as parseQuantityAndUnitFromRawValue,
    __experimentalUseCustomUnits as useCustomUnits,
    __experimentalUnitControl as UnitControl, 
    //@ts-ignore: Cannot find module '@wordpress/components' or its corresponding type declarations.
} from '@wordpress/components'



export default function HeightInput( { 
    onChange,
    onUnitChange,
    unit,
    value,
} :any ) {
    // Simplified WP Function from Cover Block (see: CoverHeightInput)
    // Compared to Cover block -> itdoes not have the option in the parent "dimensions" tab to reset, but it is simpler. ( no clientId is needed)
    const isPx = unit === 'px';
    const units = useCustomUnits( {
        availableUnits: [ 'px', 'em', 'rem', 'vh' ] ,
        defaultValues: { px: 430, '%': 50, em: 20, rem: 20, vw: 50, vh: 50 },
    } );

    const handleOnChange = ( unprocessedValue:any ) => {
        const inputValue =
            unprocessedValue !== ''
                ? parseFloat( unprocessedValue )
                : undefined;

        if ( isNaN( inputValue! ) && inputValue !== undefined ) {
            return;
        }
        onChange( inputValue );
    };

    const computedValue = useMemo( () => {
        const [ parsedQuantity ] = parseQuantityAndUnitFromRawValue( value );
        return [ parsedQuantity, unit ].join( '' );
    }, [ unit, value ] );

    const MIN_HEIGHT = 50;
    const min = isPx ? MIN_HEIGHT : 0;

    return (
        <UnitControl
            __next40pxDefaultSize
            label={ __( 'Height', 'scrollsequence' ) }
            isResetValueOnUnitChange
            min={ min }
            onChange={ handleOnChange }
            onUnitChange={ onUnitChange }
            units={ units }
            value={ computedValue }
        />
    );
}