// This function returns the ScrollsequenceFree or ScrollsequencePremium or undefined.
// This should work in both iframe and non-iframe scenarios.

declare global {
    interface Window {
        ScrollsequenceManager?: any;
    }
}

import { DBG } from '../dbg'

// export default function getScrollsequenceFop(element:HTMLElement){
//     //console.log('ScrollsequenceManager', window.ScrollsequenceManager)
//     return  window.ScrollsequenceManager;
// }

export default function getScrollsequenceFop(element: HTMLElement) {
    if (!element) {
        DBG&&console.log('getScrollsequenceFop() called without element');
        return undefined
    };

    const { ownerDocument } = element;
    const { defaultView } = ownerDocument;    
    //DBG&&console.log('getScrollsequenceFop() - defaultView:', defaultView);

    if (!defaultView) {
        DBG&&console.log('getScrollsequenceFop() called without defaultView');
        return undefined
    };

    if (defaultView.ScrollsequenceManager) {
        //DBG&&console.log('getScrollsequenceFop() - ScrollsequenceManager:');
        return defaultView.ScrollsequenceManager
    } else {
        DBG&&console.log('getScrollsequenceFop() - ScrollsequenceManager not found');
        return undefined
    }
}