//@ts-ignore
import { __ } from '@wordpress/i18n';
//@ts-ignore
import { Guide } from '@wordpress/components';
import { useState } from '@wordpress/element';
export default function C3dVariables({
    pages,
    children,
}: {
    pages: any[];
    children: (props: {
        isOpen: boolean;
        openGuide: () => void;
        closeGuide: () => void;
    }) => JSX.Element;
}) {
    const [isOpen, setIsOpen] = useState(false);

    const openGuide = () => setIsOpen(true);
    const closeGuide = () => setIsOpen(false);

    return (
        <>
            {children({ isOpen, openGuide, closeGuide })}
            {isOpen && (
                <Guide
                    onFinish={closeGuide}
                    pages={pages}
                />
            )}
        </>
    );
}

/*
EXAMPLE USE: 
<C3dVariables>
    {({ isOpen, openGuide, closeGuide }) => (
        <div>
            <button onClick={openGuide}>Open Guide</button>
            {isOpen && <p>Guide is open</p>}
        </div>
    )}
</C3dVariables>
*/