/**
 * 
 * THIS SHOULD BE SOMEWHERE "ON OUR SERVERS" - maybe? 
 *  - users should be able to add their own animations (as CPT or Taxonomy or something) and they should be visible in the list.
 *      - AI could help them to create the JSON objects 
 * 
 *  - this could be "community" thing, where if user adds his own thing, it will be visible to others.
 *  - the standard animations are "editable" with param sliders and selection of easing function, repeats, etc.
 *  - there should be a "non-reversible" button that convert the standard animation into a json and allows to "save" it as a new "text editable" JSON based animation.
 *  
 * 
 * 
 * This file stores standard content animations 
 * 
 */
export type AnimationType = {
    id: string // Unique identifier
    title: string // Displayed in the listing
    description: string // For searching (future)
    category: 'move' | 'rotate' | 'scale' | 'color' | 'advanced' // user-generated, ai-generated
    icon?: string // Icon for the listing
    data: (params: AnimationParams) => any // The data that is used to create the animation
}

export type AnimationParams = undefined | {
    x?: number 
    y?: number
    scale?: number
    rotation?: number
    color?: string
    duration?: number
    ease?: string
    // repeat
    // delay
    // ??
}

export const animations : AnimationType[] = [


    {
        id: 'fade-up-fade-out',
        title: 'Fade Up Fade Out',
        description: 'Fade Up Fade Out',
        category: 'advanced',
        icon: 'arrow-up',
        data: (params: AnimationParams = { y: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { y: Number(params.y), autoAlpha: 0 },
                    "20%": { y: 0, autoAlpha: 1,  },
                    "80%": { y: 0, autoAlpha: 1, },
                    "100%": { y: -Number(params.y), autoAlpha: 0,  },
                    //easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    }, 


    {
        id: 'appear-up',
        title: 'Appear Up',
        description: 'Appear Up',
        category: 'move',
        icon: 'arrow-up',
        data: (params: AnimationParams = { y: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { y: Number(params.y), autoAlpha: 0 },
                    "50%": { y: Number(params.y)/2, autoAlpha: 1,  },
                    "100%": { y: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    }, 

    {
        id: 'move-up',
        title: 'Move Up',
        description: 'Move Up',
        category: 'move',
        icon: 'arrow-up',
        data: (params: AnimationParams = { y: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { y: 0 },
                    "50%": { y: -Number(params.y), ease: "sine.out" },
                    "100%": { y: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    }, 
    {
        id: 'move-down',
        title: 'Move Down',
        description: 'Move Down',
        category: 'move',
        icon: 'arrow-down',
        data: (params: AnimationParams = { y: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { y: 0 },
                    "50%": { y: Number(params.y), ease: "sine.out" },
                    "100%": { y: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'move-left',
        title: 'Move Left',
        description: 'Move Left',
        category: 'move',
        icon: 'arrow-left',
        data: (params: AnimationParams = { x: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { x: 0 },
                    "50%": { x: -Number(params.x), ease: "sine.out" },
                    "100%": { x: 0, },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'move-right',
        title: 'Move Right',
        description: 'Move Right',
        category: 'move',
        icon: 'arrow-right',
        data: (params: AnimationParams = { x: 100, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { x: 0 },
                    "50%": { x: Number(params.x), ease: "sine.out" },
                    "100%": { x: 0, },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate-left',
        title: 'Rotate Left',
        description: 'Rotate Left',
        category: 'rotate',
        icon: 'rotate-left',
        data: (params: AnimationParams = { rotation: 90, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: -Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate-right',
        title: 'Rotate Right',
        description: 'Rotate Right',
        category: 'rotate',
        icon: 'rotate-right',
        data: (params: AnimationParams = { rotation: 90, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'scale-up',
        title: 'Scale Up',
        description: 'Scale Up',
        category: 'rotate',
        icon: 'scale-up',
        data: (params: AnimationParams = { scale: 1.5, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { "scale": 1 },
                    "50%": { "scale": Number(params.scale), ease: "sine.out" },
                    "100%": { "scale": 1 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'scale-down',
        title: 'Scale Down',
        description: 'Scale Down',
        category: 'scale',
        icon: 'scale-down',
        data: (params: AnimationParams = { scale: 0.5, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { "scale": 1 },
                    "50%": { "scale": Number(params.scale), ease: "sine.out" },
                    "100%": { "scale": 1 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'color-change',
        title: 'Color Change',
        description: 'Color Change',
        category: 'color',
        icon: 'color-change',
        data: (params: AnimationParams = { color: '#ff0000', duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { color: '#000000' },
                    "50%": { color: params.color, ease: "sine.out" },
                    "100%": { color: '#000000' },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'background-color-change',
        title: 'Background Color Change',
        description: 'Background Color Change',
        category: 'color',
        icon: 'background-color-change',
        data: (params: AnimationParams = { color: '#ff0000', duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { "backgroundColor": '#ffffff' },
                    "50%": { "backgroundColor": params.color, ease: "sine.out" },
                    "100%": { "backgroundColor": '#ffffff' },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate-360',
        title: 'Rotate 360',
        description: 'Rotate 360',
        category: 'color',
        icon: 'rotate-360',
        data: (params: AnimationParams = { rotation: 360, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate-180',
        title: 'Rotate 180',
        description: 'Rotate 180',
        category: 'rotate',
        icon: 'rotate-180',
        data: (params: AnimationParams = { rotation: 180, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate-90',
        title: 'Rotate 90',
        description: 'Rotate 90',
        category: 'rotate',
        icon: 'rotate-90',
        data: (params: AnimationParams = { rotation: 90, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate--90',
        title: 'Rotate -90',
        description: 'Rotate -90',
        category: 'rotate',
        icon: 'rotate--90',
        data: (params: AnimationParams = { rotation: -90, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate--180',        
        title: 'Rotate -180',
        description: 'Rotate -180',
        category: 'rotate',
        icon: 'rotate--180',
        data: (params: AnimationParams = { rotation: -180, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    },
    {
        id: 'rotate--360',
        title: 'Rotate -360',
        description: 'Rotate -360',
        category: 'rotate',
        icon: 'rotate--360',
        data: (params: AnimationParams = { rotation: -360, duration: 2 }) => {
            return {
                keyframes: {
                    "0%": { rotation: 0 },
                    "50%": { rotation: Number(params.rotation), ease: "sine.out" },
                    "100%": { rotation: 0 },
                    easeEach: "expo.inOut"
                },
                ease: "none",
                duration: Number(params.duration)
            }
        },
    }
]

export function getAnimationObject(id: string, params?: AnimationParams): any {
    const animation = animations.find(anim => anim.id === id);
    if (animation) {
        return animation.data(params);
    }
    console.warn('animation not found:', id);
    return null;
}

/**
 * 
 * SCROLLTRIGGERS
 * 
 */
export type ScrollTriggerAnimation = {
    id: string // Unique identifier
    title: string // Displayed in the listing
    description: string // For searching (future)
    icon: string // Icon for the listing
    data: ScrollTriggerObject
}
export type ScrollTriggerObject = 
undefined | // we could have a undefined value for the default trigger.
{
    pin: boolean        // TODO:!!!! This is made up, i should look in gsap docs for the correct values
    markers: boolean,   // TODO:!!!! This is made up, i should look in gsap docs for the correct values
    start: string,      // TODO:!!!! This is made up, i should look in gsap docs for the correct values
    end: string,        // TODO:!!!! This is made up, i should look in gsap docs for the correct values
    scrub: number,      // TODO:!!!! This is made up, i should look in gsap docs for the correct values
}

export const ScrollTriggerAnimations: ScrollTriggerAnimation[] = [
    {
        id: 'todo-1',
        title: 'todo 1',
        description: 'todo 1',
        icon: 'todo-1',
        data: {
            pin: true,
            markers: true,
            start: "top center",
            end: "+=300",
            scrub: 1
        }
    },
    {
        id: 'todo-2',
        title: 'todo 2',
        description: 'todo 2',
        icon: 'todo-2',
        data: {
            pin: false,
            markers: true,
            start: "top center",
            end: "+=300",
            scrub: 1
        }
    },
]

export function getScrollTriggerObject(id: string): ScrollTriggerObject | null {
    const animation = ScrollTriggerAnimations.find(anim => anim.id === id);
    if (animation) {
        return animation.data;
    }
    console.warn('scroll trigger not found:', id);
    return null;
}





/*
const sts : any[] = [
    {
        data: 
        `{
            "pin": true,
            "markers":true,
            "start": "top center", 
            "end": "+=300",
            "scrub": 1 
        }` 
    },
    {
        data: 
        `{
            "pin": false,
            "markers":true,
            "start": "top center", 
            "end": "+=300",
            "scrub": 1 
        }` 
    },
]
*/