declare const wp: any;
const { createHigherOrderComponent } = wp.compose;
const { useSelect } = wp.data // done this myself :-) so proud! <3 LOL
const { useState, useRef, useEffect } = wp.element // done this myself too :-) so proud! <3 LOL

import { withScrollsequenceAnimationControls } from './content-animation/withScrollsequenceAnimationControls'

/**
 * 1 - Add animation attributes ALL blocks except container, scene and paths. This makes it possible to save the attributes.
 */
wp.hooks.addFilter( // runs for each block.
    'blocks.registerBlockType', 
    'scroll-sequence/v2-scroll-sequence-add-animation-attributes', 
    (settings:any, name:any) => {
        if (    
            //settings.name === 'scroll-sequence/v2-canvas1d' ||  // we want it here! (new)
            //settings.name === 'scroll-sequence/v2-canvas2d' ||  // we want it here! (new)
            //settings.name === 'scroll-sequence/v2-canvas3d' ||  // we want it here! (new)  
            settings.name === 'scroll-sequence/v2-container' || // we dont want the content animation settings
            settings.name === 'scroll-sequence/v2-scene' ||  // we dont want the content animation settings
            settings.name === 'scroll-sequence/v2-paths'  // we dont want the content animation settings

        ){ 
            return settings;
        }

        if (settings.attributes) {
            settings.attributes = {
                ...settings.attributes,
                // CONTENT ANIMATION ATTRIBUTES
                ssqAnimateOnLoad:{ type: 'object', default: undefined, },
                ssqAnimateOnClick:{ type: 'object', default: undefined },
                ssqAnimateOnHover:{ type: 'object', default: undefined },
                ssqAnimateOnScroll:{ type: 'object', default: undefined },
                //ssqAnimateOnTbc:{ type: 'object', default: undefined },

                // CONTENT POINTER EVENTS
                ssqPointerEvents:{ type: 'string', default: undefined }, // undefined | 'none'

                // SCENE ALIGN ATTRIBUTES
                ssqSceneBegin:{ type: 'object', default: undefined },
                ssqSceneEnd:{ type: 'object', default: undefined },
                ssqSceneAlign:{ type: 'string', default: undefined }, // content position alignment
                //ssqSceneOffset:{ type: 'object', default: undefined }, // content position offset

            };
        }
        return settings;
    }
); 
/**
 * 2 - Adds data-ssq-animate-on-* attributes to the wrapper div
 *   Applies only if the block is inside a scroll-sequence container, scene [or paths - later], but is not itself a container or scene [or paths - later] blocks)
 */
const scrollSequenceWithDataAnimateOnProp = createHigherOrderComponent( ( BlockListBlock:any ) => {
    return ( props:any ) => {
        const { clientId, attributes } = props;
        const { 
            ssqAnimateOnLoad, ssqAnimateOnClick, ssqAnimateOnHover,ssqAnimateOnScroll,
        } = attributes;

        const parentClientNames = useSelect((select: any) => {
            const parentClientIds = select('core/block-editor').getBlockParents(clientId);
            return parentClientIds.map((id: string) => {
                const { name } = select('core/block-editor').getBlock(id) || {};
                return name;
            });
        }, [clientId]);

        const hasContainerAncestor =  parentClientNames.includes('scroll-sequence/v2-container');
        const isContainerBlock = props.name === 'scroll-sequence/v2-container';

        const hasSceneAncestor =  parentClientNames.includes('scroll-sequence/v2-scene'); 
        const isSceneBlock = props.name === 'scroll-sequence/v2-scene';

        // Decide whether we should attach the data-* wrapper props:
        // - We need at least one relevant ancestor (container OR scene)
        // - And we must NOT be the container or scene block itself
        const isHocRelevant = ( hasContainerAncestor || hasSceneAncestor ) && ! isContainerBlock && ! isSceneBlock; // !!! TODO: add paths block.

        // Early return when there's nothing to do — keeps intent explicit and readable.
        if ( ! isHocRelevant ) {
            return <BlockListBlock { ...props } />;
        }
        
        const wrapperProps = {
            ...props.wrapperProps,
            //'data-dva': 'bar',
            'data-ssq-animate-on-load':  ssqAnimateOnLoad ? JSON.stringify(ssqAnimateOnLoad) : undefined ,
            'data-ssq-animate-on-click' : ssqAnimateOnClick ? JSON.stringify(ssqAnimateOnClick) : undefined,
            'data-ssq-animate-on-hover' : ssqAnimateOnHover ? JSON.stringify(ssqAnimateOnHover) : undefined,
            'data-ssq-animate-on-scroll' : ssqAnimateOnScroll ? JSON.stringify(ssqAnimateOnScroll) : undefined,

        };
        return <BlockListBlock { ...props } wrapperProps={ wrapperProps } />;
    };
}, 'scrollSequenceWithDataAnimateOnProp' );

wp.hooks.addFilter(
    'editor.BlockListBlock',
    'scroll-sequence/with-data-animate-on-prop',
    scrollSequenceWithDataAnimateOnProp
);

/**
 * 3 - adds the controls and scene alignment (inspector, toolbar)
 */
wp.hooks.addFilter( 'editor.BlockEdit', 'scroll-sequence/v2-scroll-sequence-with-animation-controls',  withScrollsequenceAnimationControls );





